package gov.va.med.mhv.vitals.web.validator;

import java.math.BigDecimal;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

@FacesValidator(value="BodyTemperatureValidator")
public class BodyTemperatureValidator implements Validator{
	private static final BigDecimal BODYTEMPERATURE_MIN_VALUE = new BigDecimal("10");
	private static final BigDecimal BODYTEMPERATURE_MAX_VALUE = new BigDecimal("999.9");

	@Override
	public void validate(FacesContext context, UIComponent component,
			Object value) throws ValidatorException {
		
       BigDecimal temperature=(BigDecimal)value;
		
		if(temperature.compareTo(BODYTEMPERATURE_MAX_VALUE) > 0){
			String summary = "The Body Temperature value must be less than or equal to 999.99.";
			String detail = "Enter a value less than or equal to 999.99.";
			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, detail));
		}else  if(temperature.compareTo(BODYTEMPERATURE_MIN_VALUE) < 0){
			String summary = "The Body Temperature value must be greater than or equal to 10.";
			String detail = "Enter a value greater than or equal to 10.";
			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, detail));
		}
		
	}

}
